# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from DefaultConfigPlugin.HttpService import registerHttpServiceConfig
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entMan ):
   controllerVersions = ( ( 2, 'Second version of OpenStack service' ), )
   addServiceInfo( entMan.serviceCtx_, 'OpenStack', controllerVersions )
   addServiceInfo( entMan.serviceClientCtx_, 'OpenStack', controllerVersions )

   scd = entMan.lookup( 'mgmt/controller/service/config' )
   openstackService = scd.service[ 'OpenStack' ]
   openstackService.enabled = True

   config = entMan.lookup( 'mgmt/openstack/config' )
   config.serviceAclTypeVrfMap = ( 'OpenStack', )
   registerHttpServiceConfig( entMan, 'OSApi', serviceName='openstack api' )
