# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import DefaultConfigPlugin.HttpService
from ServicePluginContext import addServiceInfo
import SysdbUtil

CVX_SERVICE_NAME = 'Mcs'
HTTP_SERVICE_NAME = 'mcs'

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/capi/config' ) )
def Plugin( em ):
   controllerVersions = ( ( 1, 'Media Control Service' ), )
   addServiceInfo( em.serviceCtx_, CVX_SERVICE_NAME, controllerVersions )
   DefaultConfigPlugin.HttpService.registerHttpServiceConfig(
         em, HTTP_SERVICE_NAME, serviceName="%s web service" % HTTP_SERVICE_NAME )
   SysdbUtil.addLogFacility( em, 'MCS' )
