# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
from Debug import newDebugMessage
import Tac
import Plugins

# To be able to mount hwEpoch/status when loading plugin:
# There are some packages which just depend on Ira-lib and
# forcing this dependency makes sure that Epoch lib will be installed
# for those packages.
# pkgdeps: rpmwith %{_libdir}/preinit/HwEpoch

@Plugins.plugin( provides=[ 'debug/config/ip', 'debug/config/ipv6' ] )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "ROUTING" )
   SysdbUtil.addLogFacility( entMan, "IP6ROUTING" )
   SysdbUtil.addLogFacility( entMan, "IRA" )
   SysdbUtil.addLogFacility( entMan, "DHCP" )

   # Create the top-level debug categories 'ip' and 'ipv6'
   debugConfig = entMan.lookup( 'debug/config' )

   ip = debugConfig.subcategory.newMember( 'ip', 'IP routing' )
   general = ip.subcategory.newMember( 'general', 'General debugging' )
   general.messageType.addMember( newDebugMessage( 'verbose',
                                                    'Verbose messages' ) )
   debugConfig.subcategory.newMember( 'ipv6', 'IPV6 routing' )

   arpSource = Tac.Type( 'Arp::ArpSource' )
   arpSourceId = Tac.Type( 'Arp::ArpSource::ArpSourceId' )
   arpInputConfig = entMan.lookup( 'arp/input/config/cli' )
   arpInputConfig.source = arpSource.idToValue( arpSourceId.cli )

