# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins

# pylint: disable-msg=C0322

@Plugins.plugin( requires=( 'notificationConfig[snmp]', ) )
def Plugin( ctx ):
   ctx.lookup( 'snmp/interface/config' )

   import SnmpNotificationRegistrar
   SnmpNotificationRegistrar.registerNotifications( ctx, 'snmp',
      notifications=(
         'linkUp',
         'linkDown', ),
      delays={
         'linkDown': 0.100
         } )
