# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entMan ):
   controllerVersions = ( ( 2, 'HSC service' ), )
   # Create service config for Hsc on Sysdb that's written
   # by CLI whenever the service is enabled/disable.
   addServiceInfo( entMan.serviceCtx_, 'Hsc', controllerVersions )

   # Since there's no (explicit) Hsc service on the switch and Ebra runs
   # unconditionally (for bridging/status), add service config and enable it.
   addServiceInfo( entMan.serviceClientCtx_, 'Hsc', controllerVersions )

   # Enable the service.
   hscService = entMan.lookup( 'mgmt/controller/service/config' ).service[ 'Hsc' ]
   hscService.enabled = True
