# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( entMan ):
   # temporary registration, for SNMP
   entMan.lookup( 'routing/snmpConfig' )

   import SnmpNotificationRegistrar
   SnmpNotificationRegistrar.registerNotificationType( entMan, 'bgp',
         notifications=(
            'bgpEstablished',
            'bgpBackwardTransition',
            'aristaEstablished',
            'aristaBackwardTransition' ) )

   SnmpNotificationRegistrar.registerNotificationType( entMan, 'ospf',
         notifications=(
            'ospfNbrStateChange',
            'ospfIfStateChange',
            'ospfIfAuthFailure',
            'ospfIfConfigError' ) )

   SnmpNotificationRegistrar.registerNotificationType( entMan, 'isis',
         notifications=(
            'isisDatabaseOverload',
            'isisAttemptToExceedMaxSequence',
            'isisOwnLSPPurge',
            'isisSequenceNumberSkip',
            'isisAuthenticationTypeFailure',
            'isisAreaMismatch',
            'isisRejectedAdjacency',
            'isisAdjacencyChange' ) )

   SnmpNotificationRegistrar.registerNotificationType( entMan, 'ospfv3',
         notifications=(
            'ospfv3IfConfigError',
            'ospfv3IfRxBadPacket',
            'ospfv3IfStateChange',
            'ospfv3NbrRestartHelperStatusChange',
            'ospfv3NbrStateChange',
            'ospfv3NssaTranslatorStatusChange',
            'ospfv3RestartStatusChange' ) )
