# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
import Tac

@Plugins.plugin( provides=[ 'eventMon/config' ] )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'EVENTMON' )

   config = entMan.lookup( 'eventMon/config' )
   for tableName in ( "route", "arp", "mac", "igmpsnooping", "mroute", "lacp" ):
      config.table.newMember( tableName )
