# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from EventLib import builtinEventHandlerIs

def Plugin( entMan ):
   config = entMan.lookup( 'sys/event/config' )

   builtinEventHandlerIs( config,
      "DropCountersHandler", {
         'triggerType': 'on-counters',
         'operstatus': False,
         'ip': False,
         'ip6': False,
         'intfName': '',
         'actionKind': 'bash',
         'command': 'DropCounterLog.py -l',
         'delay': 0,
         'repeatInterval': 0,
         'asynchronous': False,
         'timeout': 20,
         'thresholdCount': 1,
         'threshold': 0,
         'pollInterval': 60,
         'countersCondition': 'bashCmd."DropCounterMonitor.py" > 0',
         'logRegex': '',
         'maintenanceUnitName': '',
         'maintenanceOper': '',
         'maintenanceStage': '',
         'maintenanceBgpPeer': '',
         'vrfName': '',
         'metricName': 'hardware-drops',
         'hasSubhandlers': False,
      } )

   builtinEventHandlerIs( config,
      "VoqDeleteEventHandler", {
         'triggerType': 'on-counters',
         'operstatus': False,
         'ip': False,
         'ip6': False,
         'intfName': '',
         'actionKind': 'log',
         'command': '',
         'delay': 0,
         'repeatInterval': 0,
         'asynchronous': False,
         'timeout': 20,
         'thresholdCount': 3,
         'threshold': 900,
         'pollInterval': 30,
         'countersCondition': '*.voqDeleteEvent.delta > 0',
         'logRegex': '',
         'maintenanceUnitName': '',
         'maintenanceOper': '',
         'maintenanceStage': '',
         'maintenanceBgpPeer': '',
         'vrfName': '',
         'metricName': '',
         'hasSubhandlers': True,
      } )
