# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins

@Plugins.plugin( provides=( 'bridging/input/config', ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'INTF' )

   cli = entMan.lookup( "bridging/input/config/cli" )
   cli.vlanConfigPriority = 100
   cli.switchIntfConfigPriority = 100

   # We always create vlan 1, so that all ports can go in it.
   # If the user has configured the system to delete vlan 1,
   # that command will be present in the startup config and
   # it will delete the vlan we configure here.

   vlan1 = cli.vlanConfig.newMember( 1 )
   cli.fdbConfig.newMember( 1 )
   vlan1.adminState = 'active'
