#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entMan ):
   controllerVersions = ( ( 1, "First version of ControllerDebug" ), )
   addServiceInfo( entMan.serviceCtx_, 'ControllerDebug', controllerVersions )
   addServiceInfo( entMan.serviceClientCtx_, 'ControllerDebug', controllerVersions )

   cvxDebugMPConfig = entMan.lookup( "controller/debug/mpconfig" )
   cvxDebugMPConfig.cdsDataDirConfig = ( "", )
   cvxMgmtDebugMPConfig = entMan.lookup( "mgmt/controller/debug/mpconfig" )
   cvxMgmtDebugMPConfig.cdcDataDirConfig = ( "", )
