# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
import ServicePluginContext

@Plugins.plugin( provides=( 'mgmt/controller/service/config',
                            'mgmt/controller/config' ) )
def Plugin( entMan ):
   # Register log facility
   SysdbUtil.addLogFacility( entMan, "CVX" )

   mgmtServiceConfigDir = entMan.lookup( 'mgmt/controller/service/config' )

   # Writing default states to configMounts
   config = entMan.lookup( 'mgmt/controller/config' )

   # instantiate child attributes only on master
   config.switchHost = ( "switchHostConfig", )
   config.heartbeatConfig = ( "switchHeartbeatConfig", )
   config.sslProfileConfig = ( "sslProfileConfig", )

   ###
   ### ControllerClient configuration
   ###
   entMan.serviceClientCtx_ = \
      ServicePluginContext.ServicePluginContext( mgmtServiceConfigDir )

   # Set CVX version
   # Version 3 adds support for secure CVX Attrlog connections
   versionWithDesc = ( ( 2, "CVXVersionConfig" ), ( 3, "CVXVersionConfig" ) )
   ServicePluginContext.addServiceInfo( entMan.serviceClientCtx_, "CVX",
                                        versionWithDesc )

