# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entityManager ):
   controllerVersions = ( ( 1, "First version of Show Command Service" ), )
   addServiceInfo( entityManager.serviceCtx_, 'CliRelay', controllerVersions,
                   enabled=True )
   clientVersions = ( ( 1, "First version of Show Command Service" ), )
   addServiceInfo( entityManager.serviceClientCtx_, 'CliRelay', clientVersions,
                   enabled=True )
