# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entityManager ):
   agentName = "BugAlert"
   controllerVersions = ( ( 1, 'First version of BugAlert service' ), )
   # Create config state for BugAlert service
   addServiceInfo( entityManager.serviceCtx_, agentName, controllerVersions,
                   enabled=False )
   # Since there's no (explicit) BugAlert service on the switch add service
   # config and enable it.
   addServiceInfo( entityManager.serviceClientCtx_, agentName, controllerVersions,
                   enabled=True )
