# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins, Tracing
from AclLib import aclTypes, aclDirections, serviceAclTypes

t0 = Tracing.trace0

def registerAclIntfCliConfig( entMan, priority, path ):
   cfg = entMan.lookup( path )

   for t in aclTypes:
      c = cfg.newConfig( t )
      for d in aclDirections:
         c.newIntf( d )
   # this has to come last
   cfg.priority = priority

def registerService( entMan, service, preService="", postService="" ):
   paramCfg = entMan.lookup( 'acl/paramconfig' )
   serviceConfig = paramCfg.newService( service )
   serviceConfig.preService = preService
   serviceConfig.postService = postService

@Plugins.plugin( provides=( 'acl/config/cli', 
                            'acl/paramconfig',
                            'acl/intf/config/cli',
                            'acl/cpconfig/cli' ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "ACL" )
   registerAclIntfCliConfig( entMan, 10, 'acl/intf/config/cli' )
   registerAclIntfCliConfig( entMan, 9, 'acl/intf/config/input/secure-monitor' )
   cfg = entMan.lookup( 'acl/config/cli' )
   cpCfg = entMan.lookup( 'acl/cpconfig/cli' )
   # populate types
   for t in aclTypes:
      cfg.newConfig( t )
   for t in serviceAclTypes:
      cpCfg.newCpConfig( t )
