# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

PriorityFlowControlConfigInfo = Tac.Type( "Dcbx::PriorityFlowControlConfigInfo" )
ApplicationPriorityEntry = Tac.Type( "Dcbx::ApplicationPriorityEntry" )
ApplicationPriorityEntryKey = Tac.Type( "Dcbx::ApplicationPriorityEntry::Key" )
def ApplicationPriorityConfigInfo( *_args, **_kwargs ):
   raise Exception( "ApplicationPriorityConfigInfo is now a Tac::Entity" )

def applicationPriorityEntry( priority, sel, protocolId ):
   key = ApplicationPriorityEntryKey( sel, protocolId )
   entry = ApplicationPriorityEntry( key, priority )
   return entry

def cliSel( sel ):
   return { 'reserved0': 'unsupported (reserved 0)',
            'ether': 'ether',
            'tcpSctp': 'tcp-sctp',
            'udp': 'udp',
            'tcpSctpUdp': 'tcp-sctp-udp',
            'reserved5': 'unsupported (reserved 5)',
            'reserved6': 'unsupported (reserved 6)',
            'reserved7': 'unsupported (reserved 7)' }[ sel ]

def selValue( sel ):
   return [ 'reserved0', 'ether', 'tcpSctp', 'udp', 'tcpSctpUdp',
           'reserved5', 'reserved6', 'reserved7' ].index( sel )

applicationTable = {
      # Add more groups here:
      'iscsi': ( ( 'tcpSctp', 860 ), ( 'tcpSctp', 3260 ) )
      }
