# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from DcbxTypes import cliSel

def trafficClassesSupportedInfoStr( tcsi ):
   return [ "Traffic classes supported: %d" % tcsi.trafficClassesSupported ]

def priorityFlowControlConfigInfoStr( pfcci ):
   lines = []
   if pfcci.willing:
      lines.append( "PFC configuration: willing" )
   else:
      lines.append( "PFC configuration: not willing" )
   if pfcci.macSecBypassCapability:
      lines.append( "not capable of bypassing MACsec" )
   else:
      lines.append( "capable of bypassing MACsec" )
   lines.append( "supports PFC on up to %d traffic classes" %
         pfcci.pfcCapability )
   if pfcci.pfcEnable:
      lines.append( "PFC enabled on priorities: %s" %
               " ".join( ( str( x ) for x in range( 8 )
                     if ( ( 1 << x ) & pfcci.pfcEnable ) ) ) )
   else:
      lines.append( "PFC not enabled on any priorities" )
   return lines

def applicationPriorityConfigInfoStr( apci ):
   lines = [ "Application priority configuration:" ]
   entryCount = len( apci.applicationPriorityEntry )
   lines.append( "%d application priorities configured%s" % (
         entryCount, ":" if entryCount else "" ) )
   for entry in apci.applicationPriorityEntry.values():
      lines.append( "  %s %d priority %d" % (
               cliSel( entry.sel ), entry.protocolId, entry.priority ) )
   return lines

_config = Tac.newInstance( "Dcbx::Config", "tmp" )
etsConfigSubtype = _config.etsConfigSubtype
etsRecommendationSubtype = _config.etsRecommendationSubtype
pfcConfigSubtype = _config.pfcConfigSubtype
applicationPriorityConfigSubtype = _config.applicationPriorityConfigSubtype
