# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Tracing import trace0 as t0        # pylint: disable-msg=E0611
import Agent

class Dcbx( Agent.Agent ):
   """The DCBX agent itself."""
   def __init__( self, entityManager ):
      Agent.Agent.__init__( self, entityManager)
      mountGroup = entityManager.mountGroup()

      self.config = mountGroup.mount( 'dcb/dcbx/config', 'Dcbx::Config', 'r' )
      # Where we write our external TLVs for LLDP to transmit.
      self.externalTlvs = mountGroup.mount(
         'l2discovery/lldp/externalTlvs/dcbx', 'Lldp::ExternalTlvConfig', 'wc' )
      self.pfcConfig = mountGroup.mount( 'dcb/pfc/config', 'Pfc::Config', 'r' )
      self.pfcStatus = mountGroup.mount( 'dcb/pfc/status', 'Pfc::Status', 'r' )
      # The following mount is explicitly mounted in order to avoid
      # implicit mount by l2discovery/lldp/status/all
      #
      # l2discovery/lldp/status/all.portStatus/<foo::ptr> ->
      # l2discovery/lldp/status/local.status/1.portStatus/<foo>
      # (type=Lldp::PortStatus, count=17, size=156byte(s))
      mountGroup.mount( 'l2discovery/lldp/status/local', 'Tac::Dir', 'ri' )
      # Where LLDP puts the unknown organizationally defined TLVs for us to
      # parse.
      self.lldpStatus = mountGroup.mount(
         'l2discovery/lldp/status/all', 'Lldp::AllStatus', 'r' )
      # Where we write the contents of the parsed incoming TLVs.
      self.status = mountGroup.mount( 'dcb/dcbx/status', 'Dcbx::Status', 'w' )

      def _finish():
         t0( "Mounts complete" )

         # pylint: disable-msg=W0201
         self.root = self.agentRoot_.newEntity( 'Dcbx::Agent::Root', 'root' )
         self.root.config = self.config
         self.root.status = self.status
         self.root.externalTlvs = self.externalTlvs
         self.root.configSm = ( self.config, self.pfcConfig,
                                self.pfcStatus, self.externalTlvs )
         self.root.receiveSm = ( self.lldpStatus, self.config, self.status )

      mountGroup.close( _finish )
