#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( entMan ):

   # Register to get vniStatusDir and vtiStatusDir from each switch connected to 
   # CVX. Mapped in as a Tac::Dir type as provided by CVX.  They are later type
   # cast to vniStatusDirV2 and vtiStatusDirV1.

   entMan.register( 'vxlan/version2/vniStatusDir/switch', 'Tac::Dir' )
   entMan.register( 'vxlan/version2/vtepStatusDir/switch', 'Tac::Dir' )
   entMan.register( 'vxlan/version2/vcsStateClientView/switch', 'Tac::Dir' )

   # Vni information published by the Vxlan Control Service
   entMan.register( 'vxlancontroller/version2/vni', 'Tac::Dir' )
   
   # VCS State published by the Vxlan Control Service
   entMan.register( 'vxlancontroller/version2/vcsState', 
                    'VxlanController::VcsStateV2' )

   # Information published by VCS for HSC
   entMan.register( 'vxlancontroller/version2/hsc/vniStatusDir',
                    'VxlanController::VniStatusDirV2' )
   entMan.register( 'vxlancontroller/version2/hsc/vcsState',
                    'VxlanController::VcsStateV2' )

   # MSS input of learned MACs
   entMan.register( 'mss/version2/vniStatusDir',
                    'VxlanController::VniStatusDirV2' )
   # Mount for VCS to read remotely learned MACs
   entMan.register( 'hsc/version2/vniStatusDir',
                    'VxlanController::VniStatusDirV2' )

   # Mount for HSC to acknowledge receipt of VcsState.
   entMan.register( 'hsc/version2/vcsStateClientView',
                    'VxlanController::VcsStateClientViewV2' )

   # Vtep config mount point published by VCS
   entMan.register( 'vxlancontroller/version2/dynVtepConfig/vcs/switch',
                    'Tac::Dir' )

   # Vtep config base dir
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfig',
                    'Tac::Dir' )

   # Vtep config written by VCS
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfig*/vcs/switch',
                    'Tac::Dir' )

   # Vtep config written by Hsc
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfig*/hsc/switch',
                    'Tac::Dir' )

   # Vtep config written by OpenStack
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfig*/openstack/switch',
                    'Tac::Dir' )

   # Mount for receiving dynVtepConfig publish request from other services
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfigReady',
                    'Tac::Dir' )

   # Mount for receiving dynVtepConfig publish request from service Vxlan
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfigReady*/vcs',
                    'VxlanController::DynVtepConfigReadyV2' )

   # Mount for receiving dynVtepConfig publish request from service Hsc
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfigReady*/hsc',
                    'VxlanController::DynVtepConfigReadyV2' )

   # Mount for receiving dynVtepConfig publish request from service OpenStack
   entMan.register( 'vxlancontroller/version2/input/dynVtepConfigReady*/openstack',
                    'VxlanController::DynVtepConfigReadyV2' )


   # Mount for receiving lRConfig publish request from other services
   entMan.register( 'vxlancontroller/version2/input/lRConfigReady',
                    'Tac::Dir' )

   # Mount for receiving lRConfig publish request from service Hsc
   entMan.register( 'vxlancontroller/version2/input/lRConfigReady*/hsc',
                    'VxlanController::ServiceReadyV2' )

   # LR config base dir
   entMan.register( 'vxlancontroller/version2/input/lRConfig',
                    'Tac::Dir' )

   # Logical router published by the Vxlan Control Service
   entMan.register( 'vxlancontroller/version2/logicalRouter', 'Tac::Dir' )

   # LR errors published by VCS
   entMan.register( 'vxlancontroller/version2/errorStatus',
                    'VxlanController::ErrorStatusV2' )

   # register with service manager
   entMan.registerService( serviceName="Vxlan" )
