# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins 
import Tracing

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "ControllerDebugServer" )

@Plugins.plugin( requires=() )
def Plugin( entMan ):
   # mount point for timestamp value
   entMan.register( 'controller*/debug*/v1*/ts', 
                    'ControllerDebug::TimestampV1' )
   entMan.register( 'controller*/debug*/v2*/pingpongserverdata',
                    'Tac::Dir' )
   entMan.register( 'controller*/debug*/v2*/serverdatadir',
                    'Tac::Dir' )
   entMan.register( 'mgmt*/controller*/debug*/v2*/clientdatadir',
                    'Tac::Dir' )
   entMan.register( 'mgmt*/controller*/debug*/v1*/ts',
                    'Tac::Dir' )
   # register with service manager
   entMan.registerService( serviceName="ControllerDebug" )

