#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( entMan ):

   # Register to get command response from each switch connected to CVX.
   # Mapped in as a Tac::Dir type as provided by CVX. They are later typecast
   # to ShowCommandResult
   
   entMan.register( 'cliRelay/version1/fromSwitch',
         'Tac::Dir' )

   # Command request published to switches. Actually other CVX service Agents
   # like BugAlert will use this to send command requests to switch. Hence
   # Tac::Dir
   
   entMan.register( 'cliRelay/version1/toSwitch',
         'Tac::Dir' )

   entMan.registerService( serviceName="CliRelay" )

