# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Tac
import Tracing
from MgmtSecuritySslStatusSm import SslStatusSm

__defaultTraceHandle__ = Tracing.Handle( "ControllerCommon" )
t1 = Tracing.trace1

MgmtSecuritySslConstants = Tac.Type( "Mgmt::Security::Ssl::Constants" )
SslFeature = Tac.Type( "Mgmt::Security::Ssl::SslFeature" )

class ControllerSslProfileStateReactor( SslStatusSm ):
   __supportedFeatures__ = [ SslFeature.sslFeatureCertKey,
                             SslFeature.sslFeatureChainedCert,
                             SslFeature.sslFeatureTrustedCert,
                             SslFeature.sslFeatureCrl,
                             SslFeature.sslFeatureTls,
                             SslFeature.sslFeatureFips,
                             SslFeature.sslFeatureCipher ]

   def __init__( self, sslStatus, profileName, handleProfileStateCb,
                 handleProfileDeleteCb, handleDhparamsResetCb=None,
                 callBackNow=True ):
      t1( "Creating SSL profile state reactor for ", profileName )
      self.handleProfileStateCb_ = handleProfileStateCb
      self.handleProfileDeleteCb_ = handleProfileDeleteCb
      self.handleDhparamsResetCb_ = handleDhparamsResetCb
      SslStatusSm.__init__( self, sslStatus, profileName, 'CVX', 
                            callBackNow=callBackNow )

   def handleProfileState( self ):
      t1( "Handle SSL profile state change" )
      self.handleProfileStateCb_()

   def handleProfileDelete( self ):
      t1( "Handle SSL profile state delete" )
      self.handleProfileDeleteCb_()

   def handleDhparamsReset( self ):
      t1( "Handle DH reset" )
      if self.handleDhparamsResetCb_:
         self.handleDhparamsResetCb_()

   def certKeyPath( self ):
      if self.profileStatus_:
         return self.profileStatus_.certKeyPath
      return None

   def trustedCertsPath( self ):
      if self.profileStatus_: 
         return self.profileStatus_.trustedCertsPath
      return None

   def crlsPath( self ):
      if self.profileStatus_:
         return self.profileStatus_.crlsPath
      return None

   def dhparamsReady( self ):
      return os.path.isfile( self.dhParamPath() ) 
   
   def dhParamPath( self ):
      return MgmtSecuritySslConstants.dhParamPath()
   
   def tlsVersion( self ):
      if self.profileStatus_:
         return self.profileStatus_.tlsVersion
      return None

   def cipherSuite( self ):
      if self.profileStatus_:
         return self.profileStatus_.cipherSuite
      return None

   def fipsMode( self ):
      if self.profileStatus_:
         return self.profileStatus_.fipsMode
      return None

   def profileState( self ):
      if self.profileStatus_:
         return self.profileStatus_.state
      return None

   def profileExists( self ):
      return bool( self.profileStatus_ )
