# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BothTrace
import Tac
import Tracing
from GenericReactor import GenericReactor

__defaultTraceHandle__ = Tracing.Handle( "ControllerRegistry" )
bt5 = BothTrace.tracef5

def createPassiveConnMgr():
   connMgrHelper = Tac.Type( "Sysdb::ConnMgrHelper" )
   configDir = connMgrHelper.connectionConfigDir()
   statusDir = connMgrHelper.connectionStatusDir()
   Tac.root[ "ConnectionManagerDir" ][ "ConnectionManagerSmWrapper"
      ].passiveConnectionManagerSm = ( configDir, statusDir )
   return Tac.root[ "ConnectionManagerDir" ][ "ConnectionManagerSmWrapper"
      ].passiveConnectionManagerSm

class ControllerRegistry( object ):
   def __init__( self, controllerdbEm, controllerdbStatus,
                 controllerdbPublishStatus,
                 clusterConfig, clusterStatus,
                 controllerServiceConfig,
                 serviceMountConfigDir, serviceMountStatusDir,
                 servicePublishConfigDir, servicePublishStatusDir,
                 serviceProxyMountConfigDir, serviceProxyMountStatusDir ):
      bt5( "Initializing Controller Registry" )
      rootDir = controllerdbEm.root()
      controllerOobConfig = clusterConfig.oobConfig
      self.controllerOobStatus = clusterStatus.oobStatus
      self.passiveConnMgr_ = createPassiveConnMgr()

      mountsRegistryDirPath = 'controller/mountsRegistry'
      mountsRegistryDir = rootDir.entity[ mountsRegistryDirPath ]

      bt5( "Creating 'root' and instantiating the Entities and SMs it contains" )
      constants = Tac.Type( "Controller::Constants" )

      local = controllerdbEm.root().parent
      self.root_ = local.newEntity( "Controllerdb::Root", "root" )
      self.root_.mountsRegistry = ( mountsRegistryDir, mountsRegistryDirPath,
                                    rootDir, constants.sysdbDefaultRoot,
                                    0xffffffff, # UINT_MAX
                                    0xffffffff/2 ) # UINT_MAX/2
      self.root_.mountsRegistrySm = ( self.root_.mountsRegistry,
                                      self.controllerOobStatus,
                                      controllerOobConfig.heartbeatConfig,
                                      serviceMountStatusDir,
                                      controllerdbPublishStatus, 
                                      controllerServiceConfig )
      self.root_.serviceConfigDirSm = ( controllerdbStatus,
                                        serviceMountConfigDir,
                                        serviceMountStatusDir,
                                        servicePublishConfigDir,
                                        servicePublishStatusDir,
                                        serviceProxyMountConfigDir,
                                        serviceProxyMountStatusDir,
                                        controllerdbPublishStatus,
                                        self.root_.mountsRegistry )
      self.root_.initialMountSm = ( serviceMountConfigDir,
                                    serviceMountStatusDir,
                                    controllerOobConfig,
                                    self.controllerOobStatus,
                                    controllerdbStatus )

      def handleEstablished( notifiee=None ):
         if self.controllerOobStatus.established:
            self.root_.controllerServiceAclSm = ( 
                  self.controllerOobStatus.established, )
         else:
            self.root_.controllerServiceAclSm = None

      self.oobStatusReactor = GenericReactor( self.controllerOobStatus, 
                                              [ 'established' ],
                                              handleEstablished,
                                              callBackNow=True )


