# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   defaultXcvrConfigCli = None
   if attrEditBypassParentDir:
      bypassXcvrConfigCliDir = attrEditBypassParentDir.newEntity(
         "Xcvr::XcvrConfigCliDir", "Xcvr" )
      defaultXcvrConfigCli = bypassXcvrConfigCliDir.xcvrConfigCli.newMember( "" )
   # We need to have config-replace ignore changes in XcvrConfigCliDirs, which
   # are precreated per-slice. This means we have to add per-slice bypasses
   xcvrConfigCliDirsParent = entMan.lookup( "hardware/xcvr/cli/config/slice" )
   for sliceName in xcvrConfigCliDirsParent:
      xcvrConfigCliDir = entMan.lookup( "hardware/xcvr/cli/config/slice/%s" %
                                        sliceName )
      CliSession.registerAttributeEditLogBypass( entMan, xcvrConfigCliDir.fullName,
                                                 "xcvrConfigCli",
                                                 "Xcvr::XcvrConfigCli", "del",
                                                 defaultXcvrConfigCli )
