# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   cli = entMan.lookup( 'stp/txRx/input/config/cli' )

   # StpTxRx CliPlugin writes to counterUpdateRequestTime upon running
   # a show command. This will lead to the attribute being reset upon
   # config replace running-config as there is no config entry for
   # setting this attribute. This is expected behavior and safe to
   # bypass.
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "counterUpdateRequestTime",
                                              "double",
                                              "set", None )
