# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   aclConfig = entMan.lookup( 'routing/acl/config' )

   # EntityCopy handler for RouteMap::Map
   routeMapHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                   "RouteMap",
                                   "Routing::RouteMap::RouteMapCopyHandlerDir" )

   # route map copy handler
   routeMapHandlerDir.routeMapCopyHandler = ()
   routeMapHandler = routeMapHandlerDir.routeMapCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenameRouteMapMode under RouteMap/CliPlugin/RouteMapCli.py
   routeMapHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Routing::RouteMap::Map",
                                         routeMapHandler )
   routeMapHandler.filteredAttribute.attributeName[ 'version' ] = True

   # route map copy handler for ConfigGroup
   routeMapHandlerDir = CliSession.registerConfigGroupCopyHandlerDir( entMan,
                                   "RouteMap",
                                   "Routing::RouteMap::RouteMapCopyHandlerDir" )
   routeMapHandlerDir.routeMapCopyHandler = ()
   routeMapHandler = routeMapHandlerDir.routeMapCopyHandler
   routeMapHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "routing/routemap/config",
                                         "Routing::RouteMap::Map",
                                         routeMapHandler,
                                         onlyConfigGroupTable=True )
   routeMapHandler.filteredAttribute.attributeName[ 'version' ] = True

   # Edit log by pass filters for community and as-path prepend versions
   rmConfigPath = entMan.lookup( 'routing/routemap/config' ).fullName
   for attr in [ 'communityAddReplaceVersion', 'communityDeleteVersion',
                 'extCommunityVersion', 'asPathPrependVersion',
                 'asPathReplaceVersion', 'largeCommunityVersion',
                 'communityFilterVersion', 'extCommunityFilterVersion',
                 'largeCommunityFilterVersion' ]:
      CliSession.registerAttributeEditLogBypass( entMan, rmConfigPath, attr, 'U32',
                                                 'set' )

   # community list entry copy handler
   routeMapHandlerDir.communityListEntryCopyHandler = ()
   communityListEntryHandler = routeMapHandlerDir.communityListEntryCopyHandler
   communityListEntryHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::CommunityListEntry",
                                         communityListEntryHandler )
   communityListEntryHandler.filteredAttribute.attributeName[ 'version' ] = True

   CliSession.registerAttributeEditLogBypass( entMan, aclConfig.fullName,
                                              'prefixListModeCount',
                                              'U32', 'set' )
   prefixListPath = aclConfig.fullName + ".prefixList"
   CliSession.registerAttributeEditLogBypass( entMan, prefixListPath,
                                              'version',
                                              'U32', 'set' )
   CliSession.registerAttributeEditLogBypass( entMan, prefixListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )
   CliSession.registerAttributeEditLogBypass( entMan,  prefixListPath,
                                              'inPrefixListMode',
                                              'bool', 'set' )
   ipv6PrefixListPath = aclConfig.fullName + ".ipv6PrefixList"
   CliSession.registerAttributeEditLogBypass( entMan, ipv6PrefixListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )
   # Prefix-list copy handler
   routeMapHandlerDir.prefixListCopyHandler = ()
   prefixListHandler = routeMapHandlerDir.prefixListCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenamePrefixList under RouteMap/CliPlugin/RouteMapCli.py
   prefixListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::PrefixList",
                                         prefixListHandler )
   prefixListHandler.filteredAttribute.attributeName[ 'version' ] = True

   # ipv6 Prefix-list copy handler
   routeMapHandlerDir.ipv6PrefixListCopyHandler = ()
   ipv6PrefixListHandler = routeMapHandlerDir.ipv6PrefixListCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenamePrefixList under RouteMap/CliPlugin/RouteMapCli.py
   ipv6PrefixListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::Ipv6PrefixList",
                                         ipv6PrefixListHandler )
   ipv6PrefixListHandler.filteredAttribute.attributeName[ 'version' ] = True

   # aspath-list copy handler
   pathListPath = aclConfig.fullName + ".pathList"
   CliSession.registerAttributeEditLogBypass( entMan, pathListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )
   routeMapHandlerDir.asPathListCopyHandler = ()
   asPathListHandler = routeMapHandlerDir.asPathListCopyHandler
   asPathListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::AsPathList",
                                         asPathListHandler )
   asPathListHandler.filteredAttribute.attributeName[ 'version' ] = True
