# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   ptpConfig = entMan.lookup( 'ptp/config' )

   # Register a config-replace attribute edit bypass for the 'delete' case,
   # with the expected default. This is necessary since to the Ptp CLI saver,
   # Ptp::IntfConfig instances with default attribute values are indistinguishable
   # from the absence of such an instance. See BUG83649 for more information.
   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   aeBypassDefault = None
   if attrEditBypassParentDir:
      configDir = attrEditBypassParentDir.newEntity(
            "Ptp::Config", "FakePtpIntfConfigDir" )
      aeBypassDefault = configDir.intfConfig.newMember( "Ethernet1", False )
   CliSession.registerAttributeEditLogBypass(
      entMan, ptpConfig.fullName, "intfConfig", "Ptp::IntfConfig", "del",
      aeBypassDefault )

   CliSession.registerEntityCopyFilter( entMan,
                                        'ptp/config',
                                        'Ptp::IntfConfig',
                                        [ 'clearCountersRequestTime' ] )

