# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSession
from MssStaticCliLib import DeviceName

def Plugin( em ):
   routeV2Config = em.lookup( "mssl3/serviceDeviceSourceConfigV2/cli" )
   policyV2Config = em.lookup( "mssl3/policySourceConfigV2/cli" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( em )
   defaultVrfConfig = None
   defaultPolicyConfig = None
   if attrEditBypassParentDir:
      defaultServiceDeviceDir = attrEditBypassParentDir.newEntity(
            "MssL3V2::ServiceDeviceSourceConfig", "serviceDevice" )
      defaultServiceDevice = defaultServiceDeviceDir.newServiceDevice(
            DeviceName( DeviceName.encode( "dev1", "", "" ) ) )
      defaultVrfConfig = defaultServiceDevice.newNetVrf( "default" )

      defaultPolicySetDir = attrEditBypassParentDir.newEntity(
            "MssL3V2::MssPolicySourceConfig", "policySet" )
      defaultPolicySet = defaultPolicySetDir.newPolicySet(
            DeviceName( DeviceName.encode( "dev1", "", "" ) ) )
      defaultPolicyConfig = defaultPolicySet.newPolicy( "default" )

   CliSession.registerAttributeEditLogBypass( em, routeV2Config.fullName,
         "timestamp", "double", "set", defaultVrfConfig )
   CliSession.registerAttributeEditLogBypass( em, policyV2Config.fullName,
         "timestamp", "double", "set", defaultPolicyConfig )

