# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliSession


def Plugin( em ):
   multicastLegacyConfig = em.lookup( "routing/multicast/legacyconfig" )
   for attr in ( "legacy", "version" ):
      for action in ( "set", "del" ):
         # We can safely ignore legacyconfig from config replace since
         # it is used to decide how to save config and its not config in itself.
         # This prevents from having to save empty modes.
         CliSession.registerAttributeEditLogBypass(
            em,
            multicastLegacyConfig.fullName,
            attr,
            "",
            action,
            None )
