# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   ipConfig = entMan.lookup( "ip/config" )
   ip6Config = entMan.lookup( "ip6/config" )
   l3ConfigDir = entMan.lookup( 'l3/intf/config' )

   import ConfigSessionPlugin.Intf # pylint: disable-msg=F0401
   ConfigSessionPlugin.Intf.registerIntfEntityFilters(
      entMan,
      "interface/config/loopback/intf",
      "Interface::LoopbackIntfConfig" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   l3ConfigDefault = None
   ipIntfConfigDefault = None
   intfConfigDefault = None
   if attrEditBypassParentDir:
      dummyL3ConfigDir = attrEditBypassParentDir.newEntity(
         "L3::Intf::ConfigDir", "DummyL3ConfigDir" )
      l3ConfigDefault = dummyL3ConfigDir.intfConfig.newMember( "" )

      dummyIpConfig = attrEditBypassParentDir.newEntity(
         "Ip::Config", "DummyIpConfig" )
      ipIntfConfigDefault = \
          dummyIpConfig.ipIntfConfig.newMember( "" )
      ipIntfConfigDefault.l3Config = l3ConfigDefault

      dummyIp6Config = attrEditBypassParentDir.newEntity(
         "Ip6::Config", "DummyIp6Config" )
      intfConfigDefault = dummyIp6Config.intf.newMember( "" )
      intfConfigDefault.l3Config = l3ConfigDefault

   CliSession.registerAttributeEditLogBypass(
      entMan, ipConfig.fullName, "ipIntfConfig", "Ip::IpIntfConfig", "del",
      ipIntfConfigDefault )

   CliSession.registerAttributeEditLogBypass(
      entMan, ip6Config.fullName, "intf", "Ip6::IntfConfig", "del",
      intfConfigDefault )

   CliSession.registerAttributeEditLogBypass(
      entMan, l3ConfigDir.fullName, "intfConfig", "L3::Intf::Config", "del",
      l3ConfigDefault )

   CliSession.registerAttributeEditLogBypass(
      entMan, ipConfig.fullName, "ipIntfConfig", "Ip::IpIntfConfig", "set",
      ipIntfConfigDefault )
   
   CliSession.registerAttributeEditLogBypass(
      entMan, ip6Config.fullName, "intf", "Ip6::IntfConfig", "set",
      intfConfigDefault )

   CliSession.registerAttributeEditLogBypass(
      entMan, l3ConfigDir.fullName, "intfConfig", "L3::Intf::Config", "set" )

   CliSession.registerAttributeEditLogBypass(
      entMan, ipConfig.fullName, "l3Config", "L3::Intf::Config", "set" )

   CliSession.registerAttributeEditLogBypass(
      entMan, ip6Config.fullName, "l3Config", "L3::Intf::Config", "set" )

   CliSession.registerConfigRootDependency(
      entMan, "l3/intf/config", "ip/config" )
   CliSession.registerConfigRootDependency(
      entMan, "l3/intf/config", "ip6/config" )

   # -------------------------------------------------------------------------
   # Custom entity copy handlers
   # -------------------------------------------------------------------------
   ipHandlerDir = CliSession.registerCopyHandlerDir( entMan, "Ip",
                                                     "Ip::IpCopyHandlerDir" )
   ipHandlerDir.ipIntfConfigCopyHandler = ()
   ipHandler = ipHandlerDir.ipIntfConfigCopyHandler
   ipHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan, "", "Ip::IpIntfConfig",
                                         ipHandler )

   ip6HandlerDir = CliSession.registerCopyHandlerDir( entMan, "Ip6",
                                                      "Ip6::Ip6CopyHandlerDir" )
   ip6HandlerDir.intfConfigCopyHandler = ()
   ip6Handler = ip6HandlerDir.intfConfigCopyHandler
   ip6Handler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan, "", "Ip6::IpIntfConfig",
                                         ip6Handler )

   l3HandlerDir = CliSession.registerCopyHandlerDir( entMan, "L3",
                                                     "L3::L3CopyHandlerDir" )
   l3HandlerDir.configCopyHandler = ()
   l3Handler = l3HandlerDir.configCopyHandler
   l3Handler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan, "", "L3::Config", l3Handler )
   l3Handler.filteredAttribute.attributeName[ 'protocolAgentModel' ] = True
