#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   intConfig = entMan.lookup( "inbandtelemetry/config" )
   CliSession.registerAttributeEditLogBypass( entMan,
                                              "inbandtelemetry/config",
                                              "version",
                                              "U32",
                                              "set" )
   for profile in intConfig.edgePortProfiles:
      parentPath = "inbandtelemetry/config/edgePortProfiles/%s" % profile
      CliSession.registerAttributeEditLogBypass( entMan,
                                                 parentPath,
                                                 "version",
                                                 "U32",
                                                 "set" )
   for profile in intConfig.corePortProfiles:
      parentPath = "inbandtelemetry/config/corePortProfiles/%s" % profile
      CliSession.registerAttributeEditLogBypass( entMan,
                                                 parentPath,
                                                 "version",
                                                 "U32",
                                                 "set" )
   inbandTelemetryConfigHandlerDir = CliSession.registerCopyHandlerDir(
         entMan,
         "InbandTelemetryConfig",
         "InbandTelemetry::InbandTelemetryConfigCopyHandlerDir" )
   inbandTelemetryConfigHandlerDir.copyHandler = ()
   inbandTelemetryConfigHandler = inbandTelemetryConfigHandlerDir.copyHandler
   inbandTelemetryConfigHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "inbandtelemetry/config",
                                         "InbandTelemetry::Config",
                                         inbandTelemetryConfigHandler )
