# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import glob
import json
import os
import CliSession
import Plugins
from PluginTree import PluginTree
import Tracing
t1 = Tracing.trace1  #verbose

@Plugins.plugin( provides=( 'session', ) )
def Plugin( entMan ):
   # The JSON files in /usr/share/ConfigSession directory contain list of attributes
   # (per entity per mountpoint) that are allowed to be rolled back when rollback
   # clean-config is used with one of the defined config groups.
   # registerEntityCopyAllowedAttrs() registers the allowed attributes that
   # have been read from /usr/share/ConfigSession
   if not os.path.isdir( "/usr/share/ConfigSession" ):
      return

   ctL = os.environ.get( "FWK_PLUGIN_CTIME_LIMIT" )
   if ctL:
      ctL = float( ctL )

   pluginTree = PluginTree( "/bld/deps", "DataPlugin" )
   filePaths = glob.glob( "/usr/share/ConfigSession/*.json" )

   for filePath in filePaths:
      fileName = os.path.basename( filePath )
      fileDir = os.path.dirname( os.path.abspath( filePath ) )
      if not pluginTree.canLoad( fileDir, fileName ):
         t1( "skipping file: %s due to deps based plugin loading ", filePath )
         continue

      fctL = os.stat( filePath ).st_ctime
      if ctL and fctL > ctL:
         t1( "skipping file: %s due to fwk_ctime limit ", filePath )
         continue

      f = open( filePath )
      json_data = f.read()
      data = json.loads( json_data )

      for item in data:
         CliSession.registerEntityCopyAllowedAttrs( entMan,
               str( item[ "Mountpoint" ] ), str( item[ "EntityTypeName" ] ),
               allowedAttrs = [ str( x ) for x in item[ "AllowedAttrs" ] ] )
