# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entityMgr ):
   bgpGroupCfg = entityMgr.lookup( 'group/config/bgp' )
   # Groups configured for dynamic units won't show up in running config. So, add a
   # log by pass filter to take care of this
   CliSession.registerAttributeEditLogBypass(
      entityMgr, bgpGroupCfg.fullName, 'config',
      'BgpGroup::Config', 'del' )

   # Make sure that vrfName gets Entity Copied first before all the other attributes
   # in BgpGroup::Config in case of config session so that the Agent code sees the
   # proper vrf where the group belongs to before creating the neighborToGroup
   # mapping for all the neighbors in the group.
   # Check BUG106175 for more details
   # The order is already ok (as defined by the Tac model). But we dont want to
   # depend on the order of attributes in Tac model alone.
   CliSession.registerEntityCopyFilter( entityMgr, '', 'BgpGroup::Config', [],
                                        orderedAttrsBefore=[ 'vrfName' ] )
