# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

class ConfigAgentPluginContext( object ):
   def __init__( self, sysname, em, mg, agent ):
      self.sysname_ = sysname
      self.em_ = em
      self.mg_ = mg
      self.agent_ = agent
      self.sms_ = []

   def registerStateMachine( self, klass ):
      self.sms_.append( klass( self.em_, self.mg_, self.agent_ ) )

   def startAllStateMachines( self ):
      for sm in self.sms_:
         sm.run()
