# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import Tac

t0 = Tracing.trace0

class ErrdisableIntfSm( object ):

   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.errdisableStatus_ = None
      self.allIntfStatusDir_ = None
      self.allIntfConfigDir_ = None
      self.errdisableIntfRoot = None
      self.redundancySm = None
      self.redundancyStatus = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.errdisableStatus_ = mg.mount( 'interface/errdisable/status',
                                         'Errdisable::Status', 'w' )
      self.redundancyStatus = self.agent_.redundancyStatus()

   def run( self ):
      t0( 'ErrdisableIntfSmStarter run' )
      # We need at least one specific blahIntf plugin loaded (say EthIntf, which will
      # create /interface/config/all), else there is no point in having an Errdisable
      # SM. If no specific interface provider exists, let's bail instead of blowing
      # up ConfigAgent, most btests don't care about that Sm, and if they do, they
      # better have a depend on the provider (like libEthIntfAgentPlugin.so).
      try:
         self.allIntfConfigDir_ = self.em_.getLocalEntity( "interface/config/all" )
      except KeyError:
         return
      self.allIntfStatusDir_ = self.em_.getLocalEntity( "interface/status/all" )
      localRoot = self.em_.root().parent
      self.errdisableIntfRoot = localRoot.newEntity( 'SysdbErrdisable::Root',
                                                     'errdisableIntfSm' )

      helper = Tac.newInstance( "Intf::ConfigAgentRedundancyModeActiveHelper",
                                self.redundancyStatus,
                                self.errdisableIntfRoot, self.allIntfConfigDir_,
                                self.allIntfStatusDir_, self.errdisableStatus_ )
      redundancyModeActiveConfig = Tac.newInstance(
            "Redundancy::RedundancyModeActiveConfig" )
      self.redundancySm = Tac.newInstance( "Redundancy::RedundancyModeActiveSm",
                                           self.redundancyStatus, helper,
                                           redundancyModeActiveConfig )

def Plugin( context ):
   context.registerStateMachine( ErrdisableIntfSm )

