# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Agent
import BothTrace
import Cli
import CliPatchSigint
import CliServerLib
import ConfigAgentName
import SysdbUtil
import Tac
import os
import resource

bt0 = BothTrace.trace0

agentNameStr = ConfigAgentName.name()

# record the entityManager in a global, so pyClient can access it.
__myEntityManager__ = None

class ConfigAgent( Agent.Agent ):
   def __init__( self, entityManager, agentName=agentNameStr, blocking=False ):
      global __myEntityManager__
      __myEntityManager__ = entityManager
      self.entMan_ = entityManager
      self.ssoStandby_ = False
      self.sysname_ = self.entMan_.sysname()
      # blocking_ is to be used in breadth tests only
      self.blocking_ = blocking
      self.agentName_ = agentName
      self.cli_ = None
      self.cliServerThread_ = None
      self.cliInitialized_ = False
      super( ConfigAgent, self ).__init__( entityManager, agentName=agentName )

   def doInit( self, entityManager ):
      bt0( 'doInit' )

      self.ssoStandby_ = SysdbUtil.onStandbySsoSupervisor()

      def cliInitialized( cli ):
         self.cli_ = cli
         self.cliServerThread_ = CliServerLib.CliServerThread( entityManager,
                                                               self.cli_ )
         self.cliServerThread_.start()
         self.cliInitialized_ = True
         bt0( "Agent is now warm" )

      # Monkey-patch Tac sigint handlers befor loading CliPlugins
      CliPatchSigint.init()
      Cli.initCli( entityManager, callback=cliInitialized,
                   block=False,
                   allowActiveMounts=False,
                   runSessionManager=True,
                   redundancyStatus=self.redundancyStatus() )

   def warm( self ):
      return self.cliInitialized_ and self.cli_ and self.cli_.pluginsComplete()

def main():
   # Opt-out of Pulse counter writing.  CliPlugins can load libraries
   # that contain Pulse counters.  Setting this env-var disables the
   # Pulse subsystem from writing the counters.  Pulse remains enabled
   # for reading, and thus the "show debug counter" commands still work.
   os.environ[ 'NOPULSE' ] = '1'

   os.environ[ 'TACC_HANDLESIGTERM' ] = "1"

   qtfile = "%s%s.qt" % ( agentNameStr, "-%d" if "QUICKTRACEDIR"
                          not in os.environ else "" )
   BothTrace.initialize( qtfile, "0,8,0,0,0,0,0,0,16,32" )

   resource.setrlimit( resource.RLIMIT_NOFILE, ( 5120, 5120 ) )
   ssoStandby = SysdbUtil.onStandbySsoSupervisor()
   bypass = not ssoStandby
   container = Agent.AgentContainer( [ ConfigAgent ],
                                     agentTitle=agentNameStr,
                                     passiveMount=True,
                                     implicitMount=True,
                                     hybridMounts=True,
                                     bypassSysdbInit=bypass,
                                     mountProfilePath="ConfigAgent*",
                                     optionalMount=True )
   container.runAgents()
