# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Cell
from CliParser import guardNotThisPlatform, guardNotThisSupervisor, guardNotPermitted

def standbyGuard( mode, token ):
   # Common guard function to disable commands on standby
   redundancyStatus = getattr( mode.entityManager, 'redundancyStatus', None )
   if redundancyStatus and redundancyStatus().mode != 'active':
      return guardNotThisSupervisor
   return None

def ssoStandbyGuard( mode, token ):
   # Common guard function to disable commands on sso standby
   locallyReadOnly = getattr( mode.entityManager, 'locallyReadOnly', None )
   if locallyReadOnly and locallyReadOnly():
      return guardNotThisSupervisor
   return None

def secureMonitorGuard( mode, token ):
   # Guard to protect commands only runnable to secure-monitor operators.
   #
   # WARNING:
   # 1. The command handler should still check for secure-monitor instead of
   # relying on the guard since guards can be disabled.
   # 2. Use allowCache=False for CliCommandClasses that use this guard, as
   # this guard depends on the user (config commands only; EXEC commands
   # don't have cache enabled).
   if Cell.cellType() == 'supervisor':
      # Do not support modulars yet
      return guardNotThisPlatform
   if mode.session.secureMonitor():
      return None
   return guardNotPermitted
