#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import os
import Tac
import Tracing
import VeosHypervisor
t0 = Tracing.t0

defaultRecoveryWaitTime = Tac.Value( 'Cloud::HA::HaPeer', 'dummy' ).\
   defaultRecoveryWaitTime

def getHypervisor():
   test_environ = os.environ.get( 'TEST_ENVIRON', None )
   if test_environ == 'AWS':
      return 'AWS'
   elif test_environ == 'Azure':
      return 'Azure'
   elif test_environ == 'GCP':
      return 'GCP'
   elif test_environ is not None:
      return 'Test_Platform'
   if os.environ.get( 'A4_CHROOT' ):
      return None
   return VeosHypervisor.getPlatform()
