#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing

t0 = Tracing.t0
t1 = Tracing.t1
t2 = Tracing.t2
t3 = Tracing.t3

class BackendResult( object ):
   def __init__( self, func, args ):
      self.func = func
      self.args = args
      # These are filled by backend called function 
      self.ret = None
      self.exception = None
      self.message = None
      self.failureType = None

   def __str__( self ):
      retStr =  'BackendResult: ' + ' Func: ' + str( self.func ) + ' Arg: ' +\
            str( self.args ) + ' Return value: ' + str( self.ret ) 
      if not self.ret:
         return retStr \
            + ( '' if not self.exception else '_Exception_: ' + self.exception ) \
            + ( '' if not self.message  else '_Msg_: ' + self.message )
      else:
         return retStr

class BackendBase( object ):

   def __init__( self ):
      self.result = None

   # Handle the RPC call from frontend
   def rpcHandler( self, args ):
      t0( ' Backend RPC handler invoked with args %s ' % args.__class__ )
      self.result = args
      assert isinstance( self.result[ 0 ], BackendResult ), \
         'Bad object passed for RPC'
      if not args or not args[ 0 ] or not args[ 0 ].func:
         t0( 'Invalid RPC call invoked in backend' )
         return
      # I don't think we need to check that indeed the func is defined as this
      # bound method of called object.
      if not self.result[0].args:
         self.result[ 0 ].ret = self.result[ 0 ].func()

   def updateResultMessage( self, msg ):
      self.result[ 0 ].message = msg

   def updateResultException( self, excpt ):
      self.result[ 0 ].exception = str( excpt )

   def updateResultFailureType( self, failureType ):
      self.result[ 0 ].failureType = failureType

   def updatePeerRouteTables( self ):
      # must be overriden in child
      assert False

   def updateLocalRouteTables( self ):
      # must be overriden in child
      assert False

   def transientFailure( self, ret ):
      return not ret and self.result[ 0 ].failureType == 'TRANSIENT'

   def configValidator( self ):
      # must be overriden in child
      assert False
