# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Various exceptions for general use.
#
import exceptions

class CloudConfigError( exceptions.Exception ):
   def __init__( self, msgstr ):
      Exception.__init__( self, 'Cloud HA Config Error( %s )' % \
         msgstr )

class MissingConfigError( CloudConfigError ):
   def __init__( self, loc ):
      super( MissingConfigError, self ).__init__( \
         'file not found or unreadable %s' % ( loc ) )
      self.loc = loc

class InvalidJson( CloudConfigError ):
   def __init__( self, fileName, msg ):
      super( InvalidJson, self).__init__( 'invalid json' )
      self.fileName = fileName
      self.error = msg

class ConfigParseError( CloudConfigError ):
   def __init__( self, msg='parse error' ):
      super( ConfigParseError, self).__init__( \
          msg )
      self.error = msg

class ConfigInvalid( CloudConfigError ):
   def __init__( self, msg ):
      super( ConfigInvalid, self ).__init__( \
         msg )
      self.error = msg

class BackendException( Exception ) :
   def __init__( self, msgstr ):
      Exception.__init__( self, msgstr )

