# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class LspPingClientState( object ):
   '''
      This class contains all global variables 
      relevant to an Mpls Ping/Traceroute Cli session
   '''
   def __init__( self ):
      self.clientIdBase = 0
      self.clientRoot = None
      self.clientRootUdpPam = None
      self.clientRootUdpPamSrcPort = None
      self.lspPingClientRootUdpPam = None
      self.ipv4RoutingSim = None
      self.ipv6RoutingSim = None
      self.clientIdBaseOverride = None

# This is global client state per mpls ping/traceroute invocation.
# Please avoid directly accessing this variable from all consuming code
# ( such as clientState._envGlobals = '42' ). Such usage will inevitably
# introduce bugs and things will eventually not end well for you. Please
# use the respective accessors and mutators below instead when appropriate,
# and add more as required.
_envGlobals = {
   'state' : {},
   'sessionId' : 0,
   'clientIdBaseOverride' : None
}

# ---------------------------------------------------------
#     Accessors and mutators for global client state
# ---------------------------------------------------------

def setGlobalClientIdBaseOverride( value ):
   global _envGlobals
   _envGlobals[ 'clientIdBaseOverride' ] = value

def sessionIdIncr( i=1 ):
   global _envGlobals
   _envGlobals[ 'sessionId' ] += i

def getCurrSessionId():
   global _envGlobals
   return _envGlobals[ 'sessionId' ]

def getGlobalState():
   global _envGlobals
   sessionId = _envGlobals[ 'sessionId' ]
   if sessionId not in _envGlobals[ 'state' ]:
      newState = LspPingClientState()
      overrideClientId = _envGlobals.get( 'clientIdBaseOverride' )
      if overrideClientId is not None:
         newState.clientIdBase = overrideClientId
      _envGlobals[ 'state' ][ sessionId ] = newState

   return _envGlobals[ 'state' ][ sessionId ]

def cleanupGlobalState():
   global _envGlobals
   sessionId = _envGlobals[ 'sessionId' ]
   if sessionId in _envGlobals[ 'state' ]:
      globalState = _envGlobals[ 'state' ][ sessionId ]
      lspPingClientRootUdpPam = globalState.lspPingClientRootUdpPam
      if lspPingClientRootUdpPam != None:
         lspPingClientRootUdpPam.doDelSocket()

def clearGlobalState():
   cleanupGlobalState()
   global _envGlobals
   _envGlobals[ 'state' ] = {}
   _envGlobals[ 'clientIdBaseOverride' ] = None

def getLspPingClientRoot( sessionId=None ):
   global _envGlobals
   return getGlobalState().clientRoot if sessionId not in _envGlobals[ 'state' ] \
   else _envGlobals[ 'state' ][ sessionId ].clientRoot

def getLspPingClientStatusColl( sessionId=None ):
   root = getLspPingClientRoot( sessionId )
   return root.lspPingClientStatusColl if root else None

def getLspPingClientConfigColl( sessionId=None ):
   root = getLspPingClientRoot( sessionId )
   return root.lspPingClientConfigColl if root else None
