#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMatcher

cliKeywordCommand = CliMatcher.KeywordMatcher(
   'command',
   helpdesc='Configuration command' )

cliKeywordRouteMap = CliMatcher.KeywordMatcher(
   'route-map',
   helpdesc='Route map configuration' )

cliKeywordPolicy = CliMatcher.KeywordMatcher(
   'policy',
   helpdesc='Policy within a route map' )

cliKeywordReference = CliMatcher.KeywordMatcher(
   'reference',
   helpdesc='Reference to other policies [in a route map]' )

cliKeywordUnconfigured = CliMatcher.KeywordMatcher(
   'unconfigured',
   helpdesc='References to unconfigured policies' )

cliKeywordAction = CliMatcher.KeywordMatcher(
   'action',
   helpdesc='Evaluation action' )

cliKeywordError = CliMatcher.KeywordMatcher(
   'error',
   helpdesc='Reject configuration as an error' )
