#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'redundancy' token in CLI

from CliCommand import Node
from CliMatcher import KeywordMatcher
import CliPlugin.RedSupCli as RedSupCli
from CliPlugin.FruCli import modularSystemGuard

redundancyForExec = KeywordMatcher( 'redundancy',
                                    helpdesc='Supervisor redundancy commands' )
redundancyForExecGuarded = Node(
      matcher=redundancyForExec,
      guard=RedSupCli.supervisorRedundancyGuard )

redundancyForGlobalConfig = KeywordMatcher( 'redundancy',
                                      helpdesc='Configure supervisor redundancy' )
redundancyForGlobalConfigGuarded = Node(
      matcher=redundancyForGlobalConfig,
      guard=RedSupCli.supervisorRedundancyGuard )

redundancyForShow = KeywordMatcher( 'redundancy',
                                    helpdesc='Supervisor redundancy information' )
redundancyForShowGuarded = Node(
      matcher=redundancyForShow,
      guard=modularSystemGuard )
