# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliMatcher
import CliCommand
import CliPlugin.LanzCli as LanzCli
import CliPlugin.AclCli as AclCli

# Collection of Matchers and Nodes useful for Lanz Cli Plugins

# MATCHERS

matcherQueueMonitor = \
  CliMatcher.KeywordMatcher( 'queue-monitor',
                              helpdesc='Configure queue-monitor' )

matcherLength = CliMatcher.KeywordMatcher( 'length',
                                            helpdesc='Monitor queue lengths' )

matcherQLen = CliMatcher.KeywordMatcher( 'length',
                                          helpdesc='Queue length information' )

matcherMirror = \
  CliMatcher.KeywordMatcher( 'mirror',
                              helpdesc='Enable frame mirroring during congestion' )

matcherDefault = \
  CliMatcher.KeywordMatcher( 'default',
             helpdesc='Configure default thresholds for Ethernet interfaces' )

matcherThresholds = \
  CliMatcher.KeywordMatcher( 'thresholds',
                              helpdesc='Configure high and low thresholds' )

matcherDefaultThresholds = \
  CliMatcher.KeywordMatcher( 'thresholds',
  helpdesc='Configure default high and low thresholds for Ethernet interfaces' )

matcherThreshold = \
  CliMatcher.KeywordMatcher( 'threshold',
                              helpdesc='Configure high threshold' )

matcherDefaultThreshold = \
  CliMatcher.KeywordMatcher( 'threshold',
             helpdesc='Configure default high threshold for Ethernet interfaces' )

matcherCpu = CliMatcher.KeywordMatcher( 'cpu', helpdesc='CPU port' )

matcherFabric = CliMatcher.KeywordMatcher( 'fabric', helpdesc='Fabric backplane' )

matcherHighThreshold = CliMatcher.DynamicIntegerMatcher(
                       LanzCli._highThresholdRangeFn, helpdesc='HighThreshold' )

matcherGlobalBufferHighThreshold = CliMatcher.DynamicIntegerMatcher(
                                   LanzCli._globalBufferHighThresholdRangeFn,
                                   helpdesc='HighThreshold' )

matcherLowThreshold = CliMatcher.DynamicIntegerMatcher(
                      LanzCli._lowThresholdRangeFn, helpdesc='LowThreshold' )

matcherGlobalBufferLowThreshold = CliMatcher.DynamicIntegerMatcher(
                                  LanzCli._globalBufferLowThresholdRangeFn,
                                  helpdesc='LowThreshold' )

matcherStreaming = CliMatcher.KeywordMatcher( 'streaming',
                                     helpdesc='Configure streaming' )

matcherStatistics = CliMatcher.KeywordMatcher( 'statistics',
                                      helpdesc='High threshold counts' )

matcherAccessList = CliMatcher.KeywordMatcher( 'access-list',
                                      helpdesc='Named access-list' )

matcherCsv = CliMatcher.KeywordMatcher( 'csv',
                        helpdesc='CSV format, with oldest samples first' )

matcherDetail = CliMatcher.KeywordMatcher( 'detail', helpdesc='Access list detail' )

matcherDrops = CliMatcher.KeywordMatcher( 'drops',
                                 helpdesc='Queue drops information' )

matcherDynamic = CliMatcher.KeywordMatcher( 'dynamic',
                            helpdesc='Dynamic (non-persistent) access-list' )

matcherGlobalBuffer = CliMatcher.KeywordMatcher( 'global-buffer',
                         helpdesc='Enable reporting of usage of global buffers' )

matcherBuffer = CliMatcher.KeywordMatcher( 'global-buffer',
                                  helpdesc='Display buffer usage' )

matcherLimit = CliMatcher.KeywordMatcher( 'limit',
                                 helpdesc='Limit samples displayed' )

matcherTxLatency = CliMatcher.KeywordMatcher( 'tx-latency',
                                     helpdesc='Display queue tx-delay' )

matcherEnableTxLatency = CliMatcher.KeywordMatcher( 'tx-latency',
                                    helpdesc='Enable tx-latency mode' )

matcherSummary = CliMatcher.KeywordMatcher( 'summary',
                                   helpdesc='Access list summary' )

matcherAll = CliMatcher.KeywordMatcher( 'all',
                        helpdesc='Display all the congestion records' )

matcherCpuPorts = CliMatcher.KeywordMatcher( 'Cpu',
                                    helpdesc='CPU port(s)' )

matcherDestination = CliMatcher.KeywordMatcher( 'destination',
                                       helpdesc='Set mirror destination' )

matcherGre = CliMatcher.KeywordMatcher( 'gre',
                               helpdesc='Gre keyword' )

matcherMode = CliMatcher.KeywordMatcher( 'mode',
                                helpdesc='Mode keyword' )

matcherTunnel = CliMatcher.KeywordMatcher( 'tunnel',
                                  helpdesc='Tunnel keyword' )

matcherNotifying = CliMatcher.KeywordMatcher( 'notifying',
                                               helpdesc='Force notifying mode' )

matcherTxLatency = CliMatcher.KeywordMatcher( 'tx-latency',
                                     helpdesc='Enable tx-latency mode' )

matcherUpdateInterval = CliMatcher.KeywordMatcher( 'update-interval',
             helpdesc='Update time interval between congestion messages' )

matcherUPDATEINTERVAL = CliMatcher.IntegerMatcher( 80, 10000000,
      helpdesc='Time interval in microseconds between two congestion messages' )

matcherPercentHighThreshold = CliMatcher.IntegerMatcher( 0, 100,
                                                helpdesc='Percentage of VOQ size' )

matcherPercentLowThreshold = CliMatcher.IntegerMatcher( 0, 100,
                                               helpdesc='Percentage of VOQ size' )

matcherPercent = CliMatcher.KeywordMatcher( 'percent',
                                             helpdesc='Percentage based threshold' )

# NODES

nodeQueueMonitor = CliCommand.Node( matcher=matcherQueueMonitor,
                                    guard=LanzCli.lanzGuard )

nodeMirror = CliCommand.Node( matcher=matcherMirror,
                              guard=LanzCli.lanzFrameMirrorGuard )

nodeCpu = \
  CliCommand.Node( matcher=matcherCpu,
                   guard=LanzCli.lanzCpuPortMonitoringSupportedGuard )

nodeFabric = CliCommand.Node( matcher=matcherFabric,
                              guard=LanzCli.lanzFabricMonitoringSupportedGuard )

nodeDefault = CliCommand.Node( matcher=matcherDefault,
                               guard=LanzCli.lanzConfigDefaultThresholdsGuard )

nodeThresholds = CliCommand.Node( matcher=matcherThresholds,
                                  guard=LanzCli.lanzLowThresholdGuard )

nodeGlobalBufferThresholds = CliCommand.Node( matcher=matcherThresholds,
                                        guard=LanzCli.lanzGlobalBufferGuard )

nodeDefaultThresholds = CliCommand.Node( matcher=matcherDefaultThresholds,
                                   guard=LanzCli.lanzLowThresholdGuard )

nodeThreshold = CliCommand.Node( matcher=matcherThreshold,
                                 guard=LanzCli.lanzForceNotifyingSupportedGuard )

nodeDefaultThreshold = CliCommand.Node( matcher=matcherDefaultThreshold,
                                  guard=LanzCli.lanzForceNotifyingSupportedGuard )

nodeStreaming = CliCommand.Node( matcher=matcherStreaming,
                                 guard=LanzCli.lanzStreamingGuard )

nodeStatistics = CliCommand.Node( matcher=matcherStatistics,
                                  guard=LanzCli.lanzStatisticsGuard )

nodeDetail = CliCommand.Node( matcher=matcherDetail,
                              guard=AclCli.countersPerChipEnabledGuard )

nodeDrops = CliCommand.Node( matcher=matcherDrops, guard=LanzCli.lanzDropGuard )

nodeGlobalBuffer = CliCommand.Node( matcher=matcherGlobalBuffer,
                                    guard=LanzCli.lanzGlobalBufferGuard )

nodeBuffer = CliCommand.Node( matcher=matcherBuffer,
                              guard=LanzCli.lanzGlobalBufferGuard )

nodeTxLatency = CliCommand.Node( matcher=matcherTxLatency,
                                 guard=LanzCli.lanzTxLatencyGuard )

nodeEnableTxLatency = CliCommand.Node( matcher=matcherEnableTxLatency,
                                 guard=LanzCli.lanzTxLatencyEnablingGuard )

nodeAll = CliCommand.Node( matcher=matcherAll,
                           guard=LanzCli.lanzGlobalBufferGuard )

nodeCpuPorts = CliCommand.Node( matcher=matcherCpuPorts,
                                guard=LanzCli.cpuPortGuard )

nodeTunnel = CliCommand.Node( matcher=matcherTunnel,
                              guard=LanzCli.mirroringDestinationGreSupported )

nodeNotifying = CliCommand.Node( matcher=matcherNotifying,
                                 guard=LanzCli.lanzForceNotifyingSupportedGuard )

nodeUpdateInterval = CliCommand.Node( matcher=matcherUpdateInterval,
                                      guard=LanzCli.lanzUpdateIntervalGuard )
