# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliMatcher import KeywordMatcher

ipLockingAddressMatcherForConfig = KeywordMatcher(
      'address',
      helpdesc='Global address locking config commands' )

ipLockingLockingMatcherForConfig = KeywordMatcher(
      'locking',
      helpdesc='Enable address locking feature' )

ipLockingAddressMatcherForConfigIf = KeywordMatcher(
      'address',
      helpdesc='Interface address locking config commands' )

ipLockingLockingMatcherForConfigIf = KeywordMatcher(
      'locking',
      helpdesc='Enable address locking feature' )

ipLockingIpv4MatcherForConfigIf = KeywordMatcher(
      'ipv4',
      helpdesc='Enable address locking for IPv4' )

ipLockingIpv6MatcherForConfigIf = KeywordMatcher(
      'ipv6',
      helpdesc='Enable address locking for IPv6' )

ipLockingAddressMatcherForShow = KeywordMatcher(
      'address',
      helpdesc='Global address locking show commands' )

ipLockingLockingMatcherForShow = KeywordMatcher(
      'locking',
      helpdesc='Display IpLocking status' )

ipLockingTableMatcherForShow = KeywordMatcher(
      'table',
      helpdesc='Display address locking table' )

ipLockingIpv4MatcherForShow = KeywordMatcher(
      'ipv4',
      helpdesc='Display the address locking table for IPv4' )

ipLockingStaticMatcherForShow = KeywordMatcher(
      'static',
      helpdesc='Only display the static leases' )

ipLockingDynamicMatcherForShow = KeywordMatcher(
      'dynamic',
      helpdesc='Only display the dynamic leases' )

ipLockingInterfasceMatcherForShow = KeywordMatcher(
      'interface',
      helpdesc='Only display the leases belong to a specified interface' )

ipLockingInstalledMatcherForShow = KeywordMatcher(
      'installed',
      helpdesc='Only display the leases that are installed in hardware' )

ipLockingAddressMatcherForClear = KeywordMatcher(
      'address',
      helpdesc='Address locking information' )

ipLockingLockingMatcherForClear = KeywordMatcher(
      'locking',
      helpdesc='Address locking information' )

ipLockingCountersMatcherForShow = KeywordMatcher(
      'counters',
      helpdesc='Address locking counters' )

ipLockingCountersMatcherForClear = KeywordMatcher(
      'counters',
      helpdesc='Clear address locking counters' )

ipLockingServersMatcherForShow = KeywordMatcher(
      'servers',
      helpdesc='Address locking servers information' )
