#!/usr/bin/env python
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'ip' token in CLI

from CliMatcher import KeywordMatcher, EnumMatcher
from CliToken.Ipv4 import ipv4MatcherForClear
from CliToken.Ipv6 import ipv6MatcherForClear

# Global config mode
ipMatcherForConfig = KeywordMatcher( 'ip',
                                     helpdesc='Global IP configuration commands' )
# Interface config mode
ipMatcherForConfigIf = KeywordMatcher( 'ip',
                                       helpdesc='Interface IP config commands' )
# Config-cp mode
ipMatcherForConfigCp = KeywordMatcher( 'ip',
                                       helpdesc='Control plane IP configuration' )
# 'clear ip'
ipMatcherForClear = KeywordMatcher( 'ip', helpdesc='Clear IP information' )
# 'show ip'
ipMatcherForShow = KeywordMatcher( 'ip', helpdesc='Details related to IPv4' )
#
ipv4MatcherForShow = KeywordMatcher( 'ipv4', helpdesc='Details related to IPv4' )
# 'refresh ip'
ipMatcherForRefresh = KeywordMatcher( 'ip', helpdesc='Refresh IP information' )

addressFamilyExprForClear = EnumMatcher( {
   ipv4MatcherForClear.keyword_ : ipv4MatcherForClear.helpdesc_,
   ipv6MatcherForClear.keyword_ : ipv6MatcherForClear.helpdesc_
} )

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Arnet/CliTokenTest.py'
