# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliMatcher import KeywordMatcher

# note: IgmpSnooping's CLI plugin will add a guard to this token
igmpNode = CliCommand.Node( matcher=KeywordMatcher(
   'igmp',
   helpdesc='IGMP related status and configuration' ) )

snoopingMatcher = KeywordMatcher(
   'snooping',
   helpdesc='IGMP snooping related status and configuration' )

queryIntervalMatcher = KeywordMatcher(
   'query-interval',
   helpdesc='Configure query interval' )

maxResponseTimeMatcher = KeywordMatcher(
   'max-response-time',
   helpdesc='Configure query response interval' )

lastMemberQueryIntervalMatcher = KeywordMatcher(
   'last-member-query-interval',
   helpdesc='Configure last member query interval' )

lastMemberQueryCountMatcher = KeywordMatcher(
   'last-member-query-count',
   helpdesc='Configure last member query count' )

startupQueryIntervalMatcher = KeywordMatcher(
   'startup-query-interval',
   helpdesc='Configure startup query interval' )

startupQueryCountMatcher = KeywordMatcher(
   'startup-query-count',
   helpdesc='Configure startup query count' )

versionMatcher = KeywordMatcher(
   'version',
   helpdesc='Configure query version' )

vlanMatcher = KeywordMatcher(
   'vlan',
   helpdesc='Specify VLAN/VLAN range ' )

robustnessVariableMatcher = KeywordMatcher(
   'robustness-variable',
   helpdesc="Number of queries to age out a port's membership in a group" )
