#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import KeywordMatcher
from CliCommand import Node
from CommonGuards import standbyGuard

idpromNode = Node( KeywordMatcher( 'idprom', helpdesc='Identification Programmable '
                                                      'Read-Only Memory' ),
                   guard=standbyGuard )

extendedNode = Node( KeywordMatcher( 'extended', helpdesc='Show hexdump of all '
                                                         'readable EEPROM pages' ),
                     guard=standbyGuard )


# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Hardware/CliTokenTest.py'
