#!/usr/bin/env python
# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliMatcher import KeywordMatcher

hardwareForConfigMatcher = KeywordMatcher(
   'hardware', helpdesc='Configure hardware-specific parameters' )
hardwareMatcherForConfig = hardwareForConfigMatcher

hardwareForExecMatcher = KeywordMatcher( 'hardware',
                                         helpdesc='Hardware EXEC commands' )
hardwareMatcherForExec = hardwareForExecMatcher

hardwareForShowMatcher = KeywordMatcher( 'hardware',
                                         helpdesc='Hardware-specific information' )
hardwareMatcherForShow = hardwareForShowMatcher

hardwareForResetMatcher = KeywordMatcher( 'hardware',
                                          helpdesc='Reset a hardware component' )
hardwareMatcherForReset = hardwareForResetMatcher

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Cli/CliTokenTest.py'
