# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher
import CliPlugin.IpAddrMatcher as IpAddrMatcher
import CliPlugin.Ip6AddrMatcher as Ip6AddrMatcher

ruleMatcher = CliMatcher.KeywordMatcher(
      'rule', helpdesc='Flow-spec rule string' )
identifierMatcher = CliMatcher.KeywordMatcher(
      'identifier', helpdesc='Flow-spec rule identifier' )
ruleIdMatcher = CliMatcher.IntegerMatcher(
      1, 0xffffffffffffffff,
      helpdesc='Flow-spec rule identifier' )

destinationMatcher = CliMatcher.KeywordMatcher(
      'destination', helpdesc='Destination prefix' )
sourceMatcher = CliMatcher.KeywordMatcher(
      'source', helpdesc='Source prefix' )

ipv4AddrMatcherForShow = IpAddrMatcher.ipPrefixExpr(
      'Network address', 'Network mask', 'Prefix',
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO,
      maskKeyword=False )
ipv6AddrMatcherForShow = Ip6AddrMatcher.Ip6PrefixValidMatcher(
      helpdesc="prefix",
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO )
