# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliMatcher import KeywordMatcher

evpnShow = KeywordMatcher( "evpn", "EVPN information" )

layer3 = KeywordMatcher( "layer-3", helpdesc="L3 IP Prefix EVPN NLRI" )

routeTypeNhSelf = KeywordMatcher( "route-type",
      helpdesc="Enable next hop self for EVPN route type" )
receivedEvpnRoutes = KeywordMatcher( "received-evpn-routes",
      helpdesc="Use local next hop for advertising received EVPN routes" )

# Add to this list for more supported NLRI route types for nexthop-self
nexthopSelfSupportNlris = {
      5 :
         { 'keyword' : 'ip-prefix',
           'helpdesc' : 'Enable nexthop self for IP prefix routes (type 5)'
         }
}
